#include <iostream>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "joystick.h"
using namespace std;

#define PORT "3490"

int main(int argc, char *argv[])
{
  padData pad;
  string padName = "/dev/input/js0";
  addrinfo hints, *result;
  int fd;
  char buf[8];
  char m1[4];
  char m2[4];
  sockaddr_storage serv_addr;
  
  memset(&hints, 0, sizeof hints);

  hints.ai_family = AF_UNSPEC;
  hints.ai_socktype = SOCK_STREAM;

  getaddrinfo(argv[1], PORT, &hints, &result);

  fd = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
  
  connect(fd, result->ai_addr, result->ai_addrlen);

  initPad(pad,padName);
  int motor1, motor2, numbytes;
  while(1)
  {
    updatePad(pad);
    memcpy(&m1, &pad.aPos[4], sizeof pad.aPos[4]);
    memcpy(&m2, &pad.aPos[1], sizeof pad.aPos[1]);
    for(int i = 0; i < 4; i++)
    {
      buf[i] = m1[i];
    }
    for(int i = 4; i < 8; i++)
    {
      buf[i] = m2[i-4];
    }
    cout << "Sent: " << numbytes << " Bytes, " << (pad.aPos[4]/364)+90 << "		" << (pad.aPos[1]/364)+90 << endl;
    numbytes = send(fd,&buf,sizeof buf, 0);
    usleep(50000);
  }
  close(fd);
  return 0;
}

  
